#!/bin/bash

. /vagrant/liferay/portal.dev.profile

# make sure httpd is installed
if [ $(sudo yum -q list installed httpd | grep -c "httpd") -ne 1 ] 
then
	if [ $(sudo yum -y install httpd | grep -c "Complete!") -ne 1 ] 
	then
		exit "Error installing Apache httpd service.";
	fi
fi

# install SSL support
sudo yum install -y mod_ssl openssl
sudo su -c "cp -v /vagrant/liferay/ssl/ca.crt /etc/pki/tls/certs"
sudo su -c "cp -v /vagrant/liferay/ssl/ca.key /etc/pki/tls/private/ca.key"
sudo su -c "cp -v /vagrant/liferay/ssl/ca.csr /etc/pki/tls/private/ca.csr"
sudo su -c "restorecon -RvF /etc/pki"

# copoy the httpd conf file into the correct location
sudo su -c "cp -v /vagrant/liferay/ssl/ssl.conf /etc/httpd/conf.d/"
sudo su -c "cp -v /vagrant/liferay/ssl/httpd.conf /etc/httpd/conf/"

# make sure httpd is running
if [ $(sudo service --status-all | grep -c "httpd .* is running...") -ne 1 ] 
then
	sudo service httpd start
else
	sudo service httpd restart
fi

exit;
